package cn.com.duiba.quanyi.center.api.remoteservice.ccbLife;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.ccbLife.CcbSubsidyDto;
import cn.com.duiba.quanyi.center.api.param.ccbLife.CcbSubsidySearchParam;
import cn.com.duiba.quanyi.center.api.param.ccbLife.RemoteLnSubsidyConfirmParam;
import cn.com.duiba.quanyi.center.api.param.ccbLife.RemoteLnSubsidySyncParam;
import cn.com.duiba.quanyi.center.api.param.ccbLife.RemoteSubsidyParam;

import java.util.List;
import java.util.Map;

/**
 * 结算补贴表
 * @author kjj mybatis generator 
 * @date 2024-03-04
 */
@AdvancedFeignClient
public interface RemoteCcbSubsidyService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 结算补贴集合
     */
    List<CcbSubsidyDto> selectPage(CcbSubsidySearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(CcbSubsidySearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 结算补贴
     */
    CcbSubsidyDto selectById(Long id);

    /**
     * 新增
     * @param dto 结算补贴
     * @return 执行结果
     */
    int insert(CcbSubsidyDto dto);

    /**
     * 更新
     * @param dto 结算补贴
     * @return 影响行数
     */
    int update(CcbSubsidyDto dto);

    /**
     * 软删
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);


    /**
     * 通过商户号批量查询 补贴金额
     * @param businessList
     * @return
     */
    Map<String,Long> getSubsidyAmountByBusinessList(List<String> businessList);

    /**
     * 通过结算ID 或者商户号查询结算明细
     * @param param
     * @return
     */
    List<CcbSubsidyDto> getConfirmList(RemoteSubsidyParam param);

    /**
     * 批量确认 批量结算数据
     * @param confirmParam
     * @return
     */
    Boolean confirmSubsidy(RemoteLnSubsidyConfirmParam confirmParam);
    /**
     * 同步门店或者商户信息
     * @param param
     * @return
     */
    Boolean batchUpdateSubsidy(RemoteLnSubsidySyncParam param);

    /**
     * 批量插入明细数据
     * @param list
     * @return
     */
    Boolean batchInsert(List<CcbSubsidyDto> list);



}