package cn.com.duiba.quanyi.center.api.remoteservice.invoice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.invoice.InvoiceApplyRefDto;

/**
 * 开票申请添加的结算单或预付款
 * @author kjj mybatis generator 
 * @date 2025-03-10
 */
@AdvancedFeignClient
public interface RemoteInvoiceApplyRefService {

    /**
     * 根据主键查询
     * @param id 主键
     * @return 开票申请添加的结算单或预付款
     */
    InvoiceApplyRefDto selectById(Long id);

    /**
     * 新增
     * @param dto 开票申请添加的结算单或预付款
     * @return 执行结果
     */
    int insert(InvoiceApplyRefDto dto);

    /**
     * 更新
     * @param dto 开票申请添加的结算单或预付款
     * @return 影响行数
     */
    int update(InvoiceApplyRefDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}