package cn.com.duiba.quanyi.center.api.remoteservice.qystatistic;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.qystatistic.WxCouponBillDetailDto;

import java.util.List;
import java.util.Set;

/**
 * 微信立减金账单详情
 *
 * @author kjj mybatis generator
 * @date 2025-01-13
 */
@AdvancedFeignClient
public interface RemoteWxCouponBillDetailService {

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 微信立减金账单详情
     */
    WxCouponBillDetailDto selectById(Long id);

    /**
     * 根据 goodsOrderNoSet 查询
     *
     * @param goodsOrderNoSet goods order no set
     * @return {@link List }<{@link WxCouponBillDetailDto }>
     */
    List<WxCouponBillDetailDto> selectByGoodsOrderNoSet(Set<String> goodsOrderNoSet);
}