package cn.com.duiba.quanyi.center.api.remoteservice.settlement.task;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.settlement.task.SettlementStatTaskDto;

import java.util.List;

/**
 * 结算单统计数据处理任务表
 * @author kjj mybatis generator 
 * @date 2024-11-30
 */
@AdvancedFeignClient
public interface RemoteSettlementStatTaskService {

    /**
     * 根据主键查询
     * @param id 主键
     * @return 结算单统计数据处理任务
     */
    SettlementStatTaskDto selectById(Long id);

    /**
     * 更改任务状态
     * @param id 主键
     * @param fromStatus 原状态
     * @param toStatus 更改后状态
     * @param errMsg 错误原因
     * @return 执行结果
     */
    int updateStatus(Long id, Integer fromStatus, Integer toStatus, String errMsg);

    /**
     * 更改已处理金额
     * @param id 主键
     * @param amount 金额
     * @return 影响行数
     */
    int updateDealAmount(Long id, Long amount);

    /**
     * 批量删除关联ID，并更新已处理金额
     * @param id 任务ID
     * @param amount 金额
     * @param refIds 关联ID列表
     * @return 是否成功
     */
    boolean batchDeleteRefAndUpdateDealAmount(Long id, Long amount, List<Long> refIds);
}