package cn.com.duiba.quanyi.center.api.remoteservice.workflow;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.workflow.WorkflowApprovalDetailDto;
import cn.com.duiba.quanyi.center.api.param.workflow.WorkflowApprovalDetailParam;
import cn.com.duiba.quanyi.center.api.param.workflow.WorkflowExecuteApprovalTaskParam;
import cn.com.duiba.quanyi.center.api.param.workflow.WorkflowStartApprovalProcessParam;

/**
 * @author lizhi
 * @date 2024/10/25 14:16
 */
@AdvancedFeignClient
public interface RemoteWorkflowService {

    /**
     * 发起审批
     * @param param 参数
     * @return 主键
     */
    Long startApprovalProcess(WorkflowStartApprovalProcessParam param);

    /**
     * 审批详情
     * @param param 参数
     * @return 审批详情
     */
    WorkflowApprovalDetailDto getApprovalDetail(WorkflowApprovalDetailParam param);

    /**
     * 执行审批任务
     * @param param 参数
     * @return 是否执行成功
     */
    boolean executeApprovalTask(WorkflowExecuteApprovalTaskParam param);

    /**
     * 终止审批实例
     * @param workflowType 审批类型
     * @see cn.com.duiba.quanyi.center.api.enums.workflow.WorkflowTypeEnum
     * @param bizId 业务ID
     * @param remark 备注
     * @param isSystem true-由系统直接终止, false-由发起人终止
     * @return 是否执行成功
     */
    boolean terminateApprovalInstance(Integer workflowType, Long bizId, String remark, boolean isSystem);
}
