package cn.com.duiba.quanyi.center.api.param.insurance;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import java.io.Serializable;
import java.util.Date;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 哈尔滨保险权益表
 * @author mybatis generator 
 * @date 2025-03-10
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class InsuranceHarbinEquitySearchParam extends PageQuery implements Serializable {
     
    private static final long serialVersionUID = 17415977810889350L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 保险公司ID，tb_insurance_company.id
     */
    private Long companyId;

    /**
     * 机构ID，tb_insurance_institution.id
     */
    private Long institutionId;

    /**
     * 坐席登录账号主键
     */
    private Long salesmanId;

    /**
     * 坐席手机号
     */
    private String salesmanPhone;

    /**
     * 坐席姓名
     */
    private String salesmanName;

    /**
     * 权益ID tb_insurance_equity.id
     */
    private Long equityId;

    /**
     * 代领人手机号
     */
    private String takePhone;

    /**
     * 保单号
     */
    private String policyNo;

    /**
     * 发放金额
     */
    private Long amount;

    /**
     * 发放状态
     */
    private Integer takeStatus;

    /**
     * 错误原因
     */
    private String errorMsg;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 是否逻辑删除, 0-未删除, 1-已删除
     */
    private Integer logicDelete = 0;

    /**
     * 删除时间
     */
    private Date logicDeleteTime;

    /**
     * 明文手机号
     */
    private String plaintextTakePhone;
}