/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.quanyi.center.api.utils.sm;

import java.io.UnsupportedEncodingException;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.pqc.math.linearalgebra.ByteUtils;

public class Sm3Util {
    public static String Sm3EncryptText(String content) throws UnsupportedEncodingException {
        byte[] bytes = content.getBytes();
        byte[] hash = Sm3Util.hash(bytes);
        return ByteUtils.toHexString((byte[])hash);
    }

    public static byte[] hash(byte[] srcData) {
        SM3Digest digest = new SM3Digest();
        digest.update(srcData, 0, srcData.length);
        byte[] bytes = new byte[digest.getDigestSize()];
        digest.doFinal(bytes, 0);
        return bytes;
    }

    public static String encryptByKey(String keyText, String plainText) {
        return ByteUtils.toHexString((byte[])Sm3Util.encryptByKey(keyText.getBytes(), plainText.getBytes()));
    }

    public static byte[] encryptByKey(byte[] keyByte, byte[] plainByte) {
        KeyParameter keyParameter = new KeyParameter(keyByte);
        SM3Digest sm3Digest = new SM3Digest();
        HMac hMac = new HMac((Digest)sm3Digest);
        hMac.init((CipherParameters)keyParameter);
        hMac.update(plainByte, 0, plainByte.length);
        byte[] result = new byte[hMac.getMacSize()];
        hMac.doFinal(result, 0);
        return result;
    }
}

