package cn.com.duiba.quanyi.center.api.dto.pay.create.ext;

import cn.com.duiba.kjy.paycenter.api.dto.psbc.PsbcPayParam;
import lombok.Data;

import java.io.Serializable;


/**
 * psbc pay create order result dto
 * <a href="https://alidocs.dingtalk.com/i/nodes/QG53mjyd80RNjDYdTOrZMkg1V6zbX04v">跳转收银台文档</>
 *
 * @author wangguanhua
 */
@Data
public class PsbcPayCreateOrderResultDto implements Serializable {

    private static final long serialVersionUID = -1521153598814574142L;

    /**
     * 跳转收银台参数
     *
     * @see PsbcPayParam#toString()
     */
    private String plain;

    /**
     * 商户号|订单号|订单金额（示例：mer2031467|AP20240912001|35.67）
     *
     * @see PsbcPayParam#getPlainText()
     */
    private String plainText;

    /**
     * 签名（使用协商的密钥（app后台提供）对plainText的值进行HMAC_SHA256数字签名，并将结果使用十六进制输出）
     */
    private String sign;

}
