package cn.com.duiba.quanyi.center.api.dto.qystatistic;

import java.io.Serializable;
import java.time.LocalDate;
import java.util.Date;
import lombok.Data;

/**
 * 微信账单重新下载统计表
 * @author mybatis generator 
 * @date 2025-01-17
 */
@Data
public class WxBillResetDownloadStatisticDto implements Serializable {
     
    private static final long serialVersionUID = 17370972883366282L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 商户号
     */
    private String mchId;

    /**
     * 批次号
     */
    private String stockId;

    /**
     * 账单日期（格式：yyyy-MM-dd）
     */
    private LocalDate billDate;

    /**
     * 账单类型：0-未结束，1-已结束
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum
     */
    private Integer billType;

    /**
     * 是否使用：0-未使用，1-已使用
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum
     */
    private Integer bizStatus;
}