package cn.com.duiba.quanyi.center.api.param.order;

import cn.com.duiba.quanyi.center.api.enums.api.ApiSpecTypeEnum;
import cn.com.duiba.quanyi.center.api.param.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.Date;
import java.util.List;

/**
 * @author xuzhigang
 * @date 2024/6/28 10:39
 **/
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class GoodsOrderEsSearchParam extends PageQuery {
    private static final long serialVersionUID = 8958867091102712341L;

    /**
     * 活动类型
     * 对应页面tab
     *  api供货 [7]
     *  兑吧卡密 [2,6]
     *  活动类 [1,3,4,5,8,9,10,12,13,14,15,16,17]
     *  车主商城 [11, 18]
     * @see cn.com.duiba.quanyi.center.api.enums.activity.BizActTypeEnum
     */
    private List<Integer> activityTypeList;

    /**
     * 订单状态集合
     * @see cn.com.duiba.quanyi.center.api.enums.goods.GoodsOrderStatusEnum
     */
    private List<Integer> orderStatusList;

    /**
     * 订单创建时间开始时间
     */
    private Date startTime;

    /**
     * 订单创建时间结束时间
     */
    private Date endTime;

    /**
     * 交易单号
     */
    private String goodsOrderNo;

    /**
     * 商品名称
     */
    private String goodsName;

    /**
     * 活动id
     * tb_activity.id
     */
    private Long activityId;

    /**
     * 活动名称
     */
    private String activityName;

    /**
     * 手机号
     */
    private String phoneNumber;

    /**
     * 订单状态
     * @see cn.com.duiba.quanyi.center.api.enums.goods.GoodsOrderStatusEnum
     */
    private Integer orderStatus;

    /**
     * 券码
     */
    private String couponCode;

    /**
     * 券链接
     */
    private String couponLink;

    /**
     * 券链接
     */
    private List<String> couponLinks;

    /**
     * 支付单号
     */
    private String payOrderNo;

    /**
     * 对接方
     */
    private String partnerName;

    /**
     * 对接id
     */
    private Long apiJointId;

    /**
     * 客户订单号
     */
    private String thirdOrderId;

    /**
     * 兑吧单号
     */
    private String mainOrderNum;

    /**
     * 车主商城订单号
     */
    private String mallOrderNo;

    /**
     * 商品库spuId
     */
    private Long spuId;

    /**
     * 奖品id
     */
    private Long prizeId;

    /**
     * 奖品idList
     */
    private List<Long> prizeIdList;

    /**
     * 调用单号
     */
    private String outBizNo;

    /**
     * 订单发放时间开始时间
     */
    private Date startGrantTime;

    /**
     * 订单发放时间结束时间
     */
    private Date endGrantTime;

    /**
     * 商品类型
     *
     * @see ApiSpecTypeEnum#getType()
     */
    private Integer specType;

    /**
     * 供应商id
     * tb_order.supplier_id
     */
    private Long supplierId;

    /**
     * tb_order.order_no
     */
    private String orderNo;

    /**
     * 商品类型
     * @see cn.com.duiba.quanyi.goods.service.api.enums.goods.SpuTypeEnum
     */
    private Integer spuType;

    /**
     * 充值账号
     */
    private String account;

    /**
     * 备注信息
     * tb_api_order.remark
     */
    private String remark;

    /**
     * 交易单号集合
     */
    private List<String> goodsOrderNoList;

    /**
     * 需求id集合
     */
    private List<Long> demandIds;

    /**
     * 需求商品id集合
     */
    private List<Long> demandGoodsIds;

    /**
     * 批次id集合
     */
    private List<String> stockIds;

    /**
     * 需求id
     */
    private Long demandId;

    /**
     * 是否有补发订单
     */
    private Integer hasReissue;

    /**
     * 是否是补发订单
     */
    private Integer isReissue;

    /**
     * 原交易单号（是补发订单时有值）
     */
    private String originalGoodsOrderNo;
}
