package cn.com.duiba.quanyi.center.api.dto.alipay;

import java.io.Serializable;
import java.util.Date;

import cn.com.duiba.quanyi.center.api.enums.alipay.AlipayActivityBillDownloadStatusEnum;
import cn.com.duiba.quanyi.center.api.enums.alipay.BillTypeEnum;
import lombok.Data;

/**
 * 支付宝立减金账单数据下载记录表
 * @author mybatis generator 
 * @date 2024-06-20
 */
@Data
public class AlipayActivityBillDownloadRecordDto implements Serializable {
     
    private static final long serialVersionUID = 17188576930788511L;

    /**
     * 主键id
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 支付宝分配给开发者的应用ID
     */
    private String alipayAppId;

    /**
     * 开始时间：格式：2020-01-01 00:00:00
     */
    private Date startTime;

    /**
     * 结束时间：格式：2020-01-01 00:00:00
     */
    private Date endTime;

    /**
     * 账单申请id
     */
    private String billId;

    /**
     * 账单类型：ALL（全部类型），writeoffBillDetail（核销），refundBillDetail（退款），dispatchBillDetail（发放）
     * {@link BillTypeEnum}
     */
    private String billType;

    /**
     * 额外信息
     */
    private String extra;

    /**
     * 状态 0-未使用，1-使用
     * {@link AlipayActivityBillDownloadStatusEnum}
     */
    private Integer bizStatus;
}