package cn.com.duiba.quanyi.center.api.param.bigdata;

import cn.com.duiba.quanyi.center.api.enums.bigdata.QueryOperatorTypeEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author chenyongkun
 * @date 2024/6/24
 */
@Data
public class BigdataQueryConditionParam implements Serializable {

    /**
     * 字段名称
     */
    private String fieldName;

    /**
     * 字段类型，默认值1（1:字符串 2:数字）
     */
    private Integer fieldType = 1;

    /**
     * 字段值
     */
    private List<Object> fieldValue;

    /**
     * 操作符，默认in，取值参考 OperatorTypeEnum
     */
    private String symbol = QueryOperatorTypeEnum.IN.toString();
}
