/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.quanyi.center.api.enums.coupon;

import cn.com.duiba.quanyi.center.api.dto.alipay.AlipayDiscountIntelligentAlgorithmJsonDto;
import cn.com.duiba.quanyi.center.api.dto.alipay.AlipayDiscountJsonDto;
import cn.com.duiba.quanyi.center.api.dto.alipay.AlipayDiscountMultiStagedDiscountJsonDto;
import cn.com.duiba.quanyi.center.api.dto.alipay.AlipayDiscountRandomJsonDto;
import cn.com.duiba.quanyi.center.api.dto.alipay.StagedThresholdInfo;
import cn.com.duiba.quanyi.center.api.enums.coupon.AmountTypeEnum;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public enum AlipayDiscountTypeEnum {
    REDUCE("reduce", "\u6ee1\u7acb\u51cf"),
    SINGLE("single", "\u5b9a\u989d\u7acb\u51cf(\u5b9a\u989d\u6ee1\u51cf)"),
    DISCOUNT("discount", "\u6298\u6263\u7acb\u51cf"),
    RANDOM("random", "\u968f\u673a\u91d1\u989d\u7acb\u51cf(\u968f\u673a\u6ee1\u51cf)"),
    INTELLIGENT_ALGORITHM("intelligentAlgorithm", "\u667a\u80fd\u7acb\u51cf"),
    MULTI_STAGED_DISCOUNT("multiStagedDiscount", "\u591a\u9636\u68af\u7acb\u51cf");

    private final String type;
    private final String desc;

    public static Integer getByType(String discountType) {
        if (REDUCE.getType().equals(discountType) || SINGLE.getType().equals(discountType)) {
            return AmountTypeEnum.FIXED.getType();
        }
        if (DISCOUNT.getType().equals(discountType) || RANDOM.getType().equals(discountType) || INTELLIGENT_ALGORITHM.getType().equals(discountType) || MULTI_STAGED_DISCOUNT.getType().equals(discountType)) {
            return AmountTypeEnum.UNFIXED.getType();
        }
        return null;
    }

    public static Pair<Long, Long> getMinAmountAndMaxAmount(String discountType, String discountValue, Long discountThresholdAmt) {
        Long minAmount;
        JSONObject jsonObject;
        JSONArray jsonArray;
        List rangeInfoList;
        Serializable jsonDto;
        if (StringUtils.isEmpty((CharSequence)discountType) || StringUtils.isEmpty((CharSequence)discountValue)) {
            return Pair.of((Object)0L, (Object)0L);
        }
        if (DISCOUNT.getType().equals(discountType) && (jsonDto = (AlipayDiscountJsonDto)JSON.parseObject((String)discountValue, AlipayDiscountJsonDto.class)) != null) {
            Long ratio = ((AlipayDiscountJsonDto)jsonDto).getRatio();
            Long minAmount2 = AlipayDiscountTypeEnum.getRatioAmount(discountThresholdAmt, ratio);
            Long maxAmount = ((AlipayDiscountJsonDto)jsonDto).getMaxAmount();
            return Pair.of((Object)minAmount2, (Object)maxAmount);
        }
        if (RANDOM.getType().equals(discountType) && CollectionUtils.isNotEmpty((Collection)(rangeInfoList = (jsonArray = (jsonObject = JSONObject.parseObject((String)discountValue)).getJSONArray("rangeInfoList")).toJavaList(AlipayDiscountRandomJsonDto.class)))) {
            AlipayDiscountRandomJsonDto alipayDiscountRandomJsonDto = (AlipayDiscountRandomJsonDto)rangeInfoList.get(0);
            Long minAmount3 = alipayDiscountRandomJsonDto.getMinAmount();
            Long maxAmount = alipayDiscountRandomJsonDto.getMaxAmount();
            return Pair.of((Object)minAmount3, (Object)maxAmount);
        }
        if (INTELLIGENT_ALGORITHM.getType().equals(discountType) && (jsonDto = (AlipayDiscountIntelligentAlgorithmJsonDto)JSON.parseObject((String)discountValue, AlipayDiscountIntelligentAlgorithmJsonDto.class)) != null) {
            minAmount = ((AlipayDiscountIntelligentAlgorithmJsonDto)jsonDto).getMinAmount();
            Long maxAmount = ((AlipayDiscountIntelligentAlgorithmJsonDto)jsonDto).getMaxAmount();
            return Pair.of((Object)minAmount, (Object)maxAmount);
        }
        if (MULTI_STAGED_DISCOUNT.getType().equals(discountType)) {
            jsonDto = (AlipayDiscountMultiStagedDiscountJsonDto)JSON.parseObject((String)discountValue, AlipayDiscountMultiStagedDiscountJsonDto.class);
            minAmount = 1L;
            List<StagedThresholdInfo> stagedDiscountList = ((AlipayDiscountMultiStagedDiscountJsonDto)jsonDto).getStagedDiscountList();
            if (CollectionUtils.isNotEmpty(stagedDiscountList)) {
                Set collect = stagedDiscountList.stream().map(stagedThresholdInfo -> {
                    String priceCalcType = stagedThresholdInfo.getPriceCalcType();
                    if ("REDUCE_TO_AMOUNT".equals(priceCalcType)) {
                        return stagedThresholdInfo.getMinThresholdAmount() - stagedThresholdInfo.getReduceAmount();
                    }
                    return stagedThresholdInfo.getReduceAmount();
                }).collect(Collectors.toSet());
                minAmount = collect.stream().min(Long::compareTo).orElse(1L);
            }
            Long maxAmount = ((AlipayDiscountMultiStagedDiscountJsonDto)jsonDto).getMaxReduceAmount();
            return Pair.of((Object)minAmount, (Object)maxAmount);
        }
        return Pair.of((Object)0L, (Object)0L);
    }

    private static Long getRatioAmount(Long discountThresholdAmt, Long ratio) {
        if (discountThresholdAmt == null || ratio == null) {
            throw new IllegalArgumentException("Input parameters cannot be null");
        }
        if (ratio == 0L) {
            throw new IllegalArgumentException("Ratio cannot be zero");
        }
        BigDecimal amount = new BigDecimal(discountThresholdAmt);
        BigDecimal rate = new BigDecimal(ratio);
        BigDecimal discount = amount.multiply(rate).divide(new BigDecimal(100), 2, RoundingMode.HALF_UP);
        return amount.subtract(discount).longValue();
    }

    public String getType() {
        return this.type;
    }

    public String getDesc() {
        return this.desc;
    }

    private AlipayDiscountTypeEnum(String type, String desc) {
        this.type = type;
        this.desc = desc;
    }
}

