package cn.com.duiba.quanyi.center.api.enums.ccb;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author xuzhigang
 * @date 2024/11/19 10:50
 **/
@Getter
@AllArgsConstructor
public enum CcbSiChuanHuiMeiOrderStatusEnum {

    INIT(0, "初始化"),

    PAY_SUCCESS(1, "支付成功且银行类型符合要求"),

    PUSH_SUCCESS(2, "推送成功"),

    PUSH_FAIL(3, "明确推送失败，建行返回失败原因的，可重复发起支付"),
    ;

    private final Integer status;

    private final String desc;

    public static boolean canPay(Integer status) {
        return INIT.status.equals(status) || PUSH_FAIL.status.equals(status);
    }

    public static boolean canPush(Integer status) {
        return PAY_SUCCESS.getStatus().equals(status);
    }
}
