package cn.com.duiba.quanyi.center.api.enums.insurance;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author lizhi
 * @date 2024/3/4 14:36
 */
@Getter
@AllArgsConstructor
public enum InsuranceEquityVerificationStatusEnum {
    NOT_VERIFICATION(1, "未核销"),
    PART_VERIFICATION(2, "部分核销"),
    ALL_VERIFICATION(3, "全部核销");

    private final Integer status;

    private final String desc;

    private static final Map<Integer, InsuranceEquityVerificationStatusEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(InsuranceEquityVerificationStatusEnum::getStatus, Function.identity(), (v1, v2) -> v2)));

    /**
     * 根据枚举值获取枚举
     * @param status 枚举值
     * @return 枚举
     */
    public static InsuranceEquityVerificationStatusEnum getByStatus(Integer status) {
        if (status == null) {
            return null;
        }
        return ENUM_MAP.get(status);
    }
}
