package cn.com.duiba.quanyi.center.api.param.qy.bill.coupon;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Date;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * 微信批次已结束账单下载记录表
 * @author mybatis generator 
 * @date 2024-11-28
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class WxCouponEndBillDownloadRecordSearchParam extends PageQuery implements Serializable {
     
    private static final long serialVersionUID = 17327831878423624L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 商户ID
     */
    private String mchId;

    /**
     * 微信批次号
     */
    private String stockId;

    /**
     * 微信活动批次主键ID
     */
    private Long activityId;

    /**
     * 记录日期，格式：yyyy-MM-dd
     */
    private LocalDate recordDate;

    /**
     * 使用状态：0-未使用，1-已使用
     */
    private Integer bizStatus;

    /**
     * 额外信息
     */
    private String extra;
}