package cn.com.duiba.quanyi.center.api.remoteservice.activity;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.activity.ActivityPrizeDto;
import cn.com.duiba.quanyi.center.api.param.activity.ActivityPrizeQueryParam;
import cn.com.duiba.quanyi.center.api.param.activity.ActivityPrizeSkuQueryParam;

import java.util.List;
import java.util.Set;

/**
 * 活动奖品表
 *
 * @author kjj mybatis generator
 * @date 2023-08-07
 */
@AdvancedFeignClient
public interface RemoteActivityPrizeService {
    /**
     * 新增
     *
     * @param activityPrizeDto 活动奖品
     * @return 执行结果
     */
    Long add(ActivityPrizeDto activityPrizeDto);

    /**
     * 根据活动id和发放方式查询
     *
     * @param activityId 活动id
     * @param grantType 发放方式
     * @see cn.com.duiba.quanyi.center.api.enums.goods.GoodsOrderGrantTypeEnum
     * @return 活动奖品
     */
    List<ActivityPrizeDto> selectByActivityIdAndGrantType(Long activityId, Integer grantType);


    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 活动奖品
     */
    ActivityPrizeDto selectById(Long id);

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 活动奖品
     */
    ActivityPrizeDto selectByIdContainDelete(Long id);

    /**
     * 根据主键批量查询
     *
     * @param ids 主键集合
     * @return 活动奖品列表
     */
    List<ActivityPrizeDto> selectByIds(Set<Long> ids);

    /**
     * 根据主键批量查询(包含已删除的)
     *
     * @param ids 主键集合
     * @return 活动奖品列表
     */
    List<ActivityPrizeDto> selectByIdsContainDelete(Set<Long> ids);

    /**
     * 更新
     *
     * @param activityPrizeDto 活动奖品
     * @return 执行结果
     */
    int update(ActivityPrizeDto activityPrizeDto);

    /**
     * 物理删除
     *
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);

    /**
     * 根据父级奖品ID查询奖品
     *
     * @param parentPrizeId 父级奖品ID
     * @return 活动奖品列表
     */
    List<ActivityPrizeDto> selectByParentPrizeId(Long parentPrizeId);

    /**
     * 根据活动id查询奖品列表
     *
     * @param activityId 活动id
     * @return 活动奖品
     */
    List<ActivityPrizeDto> selectByActivityId(Long activityId);

    /**
     * 根据活动id以及奖品类型查询奖品列表
     *
     * @param activityId 活动id
     * @param prizeTypeList 奖品类型集合，为空查询所有类型
     * @return 活动奖品
     */
    List<ActivityPrizeDto> selectByActivityIdAndTypes(Long activityId, List<Integer> prizeTypeList);
    /**
     * 根据活动id集合以及奖品类型查询奖品列表
     *
     * @param activityIdList 活动id集合
     * @param prizeTypeList 奖品类型集合，为空查询所有类型
     * @return 活动奖品
     */
    List<ActivityPrizeDto> selectByActivityIdListAndTypes(List<Long> activityIdList, List<Integer> prizeTypeList);

    /**
     * 根据活动id批量查询奖品列表
     *
     * @param activityIds 活动id
     * @return 活动奖品
     */
    List<ActivityPrizeDto> selectByActivityIds(Set<Long> activityIds);

    /**
     * 分页查询（必须使用 activity_id 过滤，防止后续模糊匹配时 SQL 超时）
     *
     * @param param param
     * @return 活动
     */
    List<ActivityPrizeDto> selectPageByPrizeName(ActivityPrizeQueryParam param);

    /**
     * count（必须使用 activity_id 过滤，防止后续模糊匹配时 SQL 超时）
     *
     * @param param param
     * @return {@link Integer}
     */
    Integer countByPrizeName(ActivityPrizeQueryParam param);

    /**
     * 插入总库存
     *
     * @param prizeId 奖品id
     * @param totalNum 总库存
     * @return 是否成功
     */
    boolean insertTotalNum(Long prizeId, Long totalNum);

    /**
     * 更新总库存
     *
     * @param id 主键id
     * @param totalNum 总库存
     * @return 更新结果
     */
    boolean updateTotalNum(Long id, Long totalNum);

    /**
     * 根据需求商品id查询
     *
     * @param demandGoodsId demand goods id
     * @return 活动奖品
     */
    List<ActivityPrizeDto> selectByDemandGoodsId(Long demandGoodsId);

    /**
     * 根据需求商品id查询
     *
     * @return 活动奖品
     */
    List<ActivityPrizeDto> selectByDemandGoodsIds(Set<Long> demandGoodsIds);

    /**
     * 根据供应商sku查询奖品列表
     * @param param 查询参数
     * @return 奖品列表
     */
    List<ActivityPrizeDto> getActivityPrizeBySku(ActivityPrizeSkuQueryParam param);
}