package cn.com.duiba.quanyi.center.api.remoteservice.qystatistic;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.qystatistic.OrderStatDailyDto;
import cn.com.duiba.quanyi.center.api.param.qystatistic.OrderStatDailySearchParam;
import java.util.List;

/**
 * 订单统计表-日维度
 * @author kjj mybatis generator 
 * @date 2025-02-26
 */
@AdvancedFeignClient
public interface RemoteOrderStatDailyService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 订单统计-日维度集合
     */
    List<OrderStatDailyDto> selectList(OrderStatDailySearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 订单统计-日维度
     */
    OrderStatDailyDto selectById(Long id);

    /**
     * 新增
     * @param dto 订单统计-日维度
     * @return 执行结果
     */
    int insert(OrderStatDailyDto dto);

    /**
     * 更新
     * @param dto 订单统计-日维度
     * @return 影响行数
     */
    int update(OrderStatDailyDto dto);
}