package cn.com.duiba.quanyi.center.api.dto.insurance.equity;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 历史保单表
 * @author mybatis generator 
 * @date 2024-03-22
 */
@Data
public class InsuranceEquityHistoryDto implements Serializable {
     
    private static final long serialVersionUID = 1711095688834440L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 所属机构
     */
    private String institutionName;

    /**
     * 发放坐席
     */
    private String salesmanName;

    /**
     * 车险保单号
     */
    private String carPolicyNo;

    /**
     * 客户手机号
     */
    private String customerPhone;

    /**
     * 车牌号
     */
    private String carNumber;

    /**
     * 车险保费
     */
    private Long carPolicyAmount;

    /**
     * 车险权益费
     */
    private Long carEquityAmount;

    /**
     * 非车保单号
     */
    private String nonCarPolicyNo;

    /**
     * 非车保费
     */
    private Long nonPolicyAmount;

    /**
     * 非车权益费
     */
    private Long nonEquityAmount;

    /**
     * 发放时间
     */
    private Date grantTime;

    /**
     * 公司ID
     */
    private Long companyId;

    /**
     * 代领人姓名
     */
    private String takeProxyName;

    /**
     * 代领人电话
     */
    private String takeProxyPhone;

    /**
     * 发放方式：1-一次性发放，2-分批发放
     * @see cn.com.duiba.quanyi.center.api.enums.insurance.InsuranceEquityGrantTypeEnum
     */
    private Integer grantType;
}