package cn.com.duiba.quanyi.center.api.enums.settlement.receive;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 回款到款方式
 * @author lizhi
 * @date 2024/12/11 14:20
 */
@AllArgsConstructor
@Getter
public enum SettlementReceivedMethodEnum {
    TO_PUBLIC(1, "对公转账"),
    TO_PRIVATE(2, "对私打款"),
    ;
    
    private final Integer method;
    
    private final String name;
    
    private static final Map<String, SettlementReceivedMethodEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(SettlementReceivedMethodEnum::getName, Function.identity(), (v1, v2) -> v2)));
    
    /**
     * 根据名称获取枚举
     * @param name 名称
     * @return 枚举
     */
    public static SettlementReceivedMethodEnum getByName(String name) {
        if (name == null) {
            return null;
        }
        return ENUM_MAP.get(name);
    }
}
