package cn.com.duiba.quanyi.center.api.remoteservice.activity;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.activity.ActivityTaskConfigDto;
import cn.com.duiba.quanyi.center.api.param.activity.ActivityTaskConfigSearchParam;
import java.util.List;

/**
 * 活动定时配置表
 * @author kjj mybatis generator 
 * @date 2025-03-20
 */
@AdvancedFeignClient
public interface RemoteActivityTaskConfigService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 活动定时配置集合
     */
    List<ActivityTaskConfigDto> selectPage(ActivityTaskConfigSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(ActivityTaskConfigSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 活动定时配置
     */
    ActivityTaskConfigDto selectById(Long id);

    /**
     * 新增
     * @param dto 活动定时配置
     * @return 执行结果
     */
    int insert(ActivityTaskConfigDto dto);

    /**
     * 更新
     * @param dto 活动定时配置
     * @return 影响行数
     */
    int update(ActivityTaskConfigDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
    /**
     * 根据活动Id查询
     * @param activityId 活动Id
     * @return
     */
    List<ActivityTaskConfigDto> selectByActivityCache(Long activityId);

    /**
     * 批量新增
     * @param dtoList
     * @return
     */
    int batchInsert(List<ActivityTaskConfigDto> dtoList);

    /**
     * 新增或编辑(编辑时先删后新增)
     * @param list
     * @return
     */
    int saveOrUpdate(List<ActivityTaskConfigDto> list);

    /**
     * 批量更新“可用状态”
     * @param ids
     * @return
     */
    int batchUpdateAvailableFlag(List<Long> ids, Integer availableFlag);

    /**
     * 根据活动Id查询
     * @param activityId 活动Id
     * @return 活动定时配置
     */
    List<ActivityTaskConfigDto> selectByActivityId(Long activityId);
}