package cn.com.duiba.quanyi.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.common.SpreadLinkDto;
import cn.com.duiba.quanyi.center.api.param.common.SpreadLinkAddParam;
import org.apache.commons.lang3.tuple.Pair;

import java.util.List;

/**
 * 推广链接表
 *
 * @author lizhi
 * @date 2023/9/19 18:44
 */
@AdvancedFeignClient
public interface RemoteSpreadLinkService {

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 推广链接
     */
    SpreadLinkDto selectById(Long id);

    /**
     * 根据主键查询
     *
     * @param channelBizType 渠道类型
     * @param channelId      渠道id
     * @return 推广链接
     */
    SpreadLinkDto selectByChannelId(Integer channelBizType, Long channelId);


    /**
     * 新增
     *
     * @param entity 推广链接
     * @return 执行结果
     */
    Long insert(SpreadLinkDto entity);

    /**
     * 更新
     *
     * @param entity 推广链接
     * @return 执行结果
     */
    int update(SpreadLinkDto entity);

    /**
     * 更新推广短链
     *
     * @param id     主键
     * @param outUrl 推广短链
     * @return 执行结果
     */
    int updateOutUrl(Long id, String outUrl);


    /**
     * 新增推广链接
     *
     * @param param 请求参数
     * @return 推广链接
     */
    SpreadLinkDto save(SpreadLinkAddParam param);

    /**
     * 初始化
     * @param id 主键
     * @param initChannelTypeList 初始化的类型
     * @return 初始化后的对象
     */
    SpreadLinkDto init(Long id, List<Integer> initChannelTypeList);

    /**
     * 根据主键获取 appId+path
     * @param id 主键
     * @return left：appId，right：path
     */
    Pair<String, String> getPath(Long id);

    /**
     * 获取小程序h5链接
     * @param id 主键
     * @return 小程序h5链接
     */
    String getMpH5Url(Long id);

    /**
     * 获取公众号链接
     * @param id 主键
     * @return 公众号链接
     */
    String getOaUrl(Long id);

    /**
     * 获取普通h5链接
     * @param id 主键
     * @return 公众号链接
     */
    String getH5Url(Long id);

    /**
     * 获取 公众号H5(小程序包装) 地址
     * @param id 主键
     * @return 公众号H5(小程序包装) 地址
     */
    String getOaMpUrl(Long id);

    /**
     * 获取 公众号h5(app渠道自动唤端) 地址
     * @param id 主键
     * @return 公众号h5(app渠道自动唤端) 地址
     */
    String getOaAutoUrl(Long id);
}
