package cn.com.duiba.quanyi.center.api.dto.settlement.prepayment;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 预付款抵扣
 * @author mybatis generator 
 * @date 2025-03-05
 */
@Data
public class PrepaymentDeductionDto implements Serializable {
     
    private static final long serialVersionUID = 1741154824680341L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 项目ID
     */
    private Long projectId;

    /**
     * 预付款ID
     */
    private Long prepaymentId;

    /**
     * 使用抵扣的发票申请id
     */
    private Long invoiceApplyId;

    /**
     * 使用抵扣的结算单ID
     */
    private Long settlementId;

    /**
     * 结算分类
     * @see cn.com.duiba.quanyi.center.api.enums.settlement.SettlementClassificationEnum
     */
    private Integer settlementClassification;

    /**
     * 抵扣金额
     */
    private Long deductionAmount;

    /**
     * 抵扣状态, 0-已撤销，1-已抵扣
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum
     */
    private Integer deductionStatus;
}