/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.quanyi.center.api.enums.demand;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum MainStatusEnum {
    NOT_COMMIT(1, "\u5f85\u63d0\u4ea4", Boolean.FALSE),
    COMMIT_FAIL(2, "\u63d0\u4ea4\u5931\u8d25", Boolean.FALSE),
    RUNNING(3, "\u5ba1\u6838\u4e2d", Boolean.TRUE),
    WAIT_PAY(4, "\u5f85\u4ed8\u6b3e", Boolean.TRUE),
    TERMINATED(5, "\u5df2\u64a4\u56de", Boolean.TRUE),
    REFUSE(6, "\u5df2\u62d2\u7edd", Boolean.TRUE),
    AGREE(7, "\u5df2\u5b8c\u6210", Boolean.TRUE),
    DELETE(8, "\u5df2\u5220\u9664", Boolean.TRUE);

    private final Integer status;
    private final String desc;
    private final Boolean show;
    private static final Map<Integer, MainStatusEnum> ENUM_MAP;
    private static final Set<Integer> FINANCE_SHOW_STATUS;

    public static Set<Integer> getFinanceShowStatus() {
        return FINANCE_SHOW_STATUS;
    }

    public static MainStatusEnum getByStatus(Integer status) {
        if (status == null) {
            return null;
        }
        return ENUM_MAP.get(status);
    }

    private MainStatusEnum(Integer status, String desc, Boolean show) {
        this.status = status;
        this.desc = desc;
        this.show = show;
    }

    public Integer getStatus() {
        return this.status;
    }

    public String getDesc() {
        return this.desc;
    }

    public Boolean getShow() {
        return this.show;
    }

    static {
        ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(MainStatusEnum.values()).collect(Collectors.toMap(MainStatusEnum::getStatus, Function.identity(), (v1, v2) -> v2)));
        FINANCE_SHOW_STATUS = Collections.unmodifiableSet(new HashSet<Integer>(Arrays.asList(WAIT_PAY.getStatus(), TERMINATED.getStatus(), REFUSE.getStatus(), AGREE.getStatus(), DELETE.getStatus())));
    }
}

