package cn.com.duiba.quanyi.center.api.param.pay;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.Date;

/**
 * @author xuzhigang
 * @date 2025/3/19 19:22
 **/
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class PayOrderEsSearchParam extends PageQuery {
    private static final long serialVersionUID = -8019134160184610010L;

    /**
     * 银行用户id
     */
    private String bankUserId;

    /**
     * 用户id
     */
    private Long userId;

    /**
     * 活动id
     */
    private Long activityId;

    /**
     * 活动名称
     */
    private String activityName;

    /**
     * 兑吧支付单号
     */
    private String bizOrderNo;

    /**
     * 渠道支付单号
     */
    private String outTradeNo;

    /**
     * 支付开始时间
     */
    private Date paidStartTime;

    /**
     * 支付结束时间
     */
    private Date paidEndTime;

    /**
     * 支付状态
     * @see cn.com.duiba.quanyi.center.api.enums.pay.PayStatusEnum
     */
    private Integer payStatus;

    /**
     * 自定义搜索1
     */
    private String extParam1;

    /**
     * 自定义搜索2
     */
    private String extParam2;

    /**
     * 自定义搜索3
     */
    private String extParam3;
}
