package cn.com.duiba.quanyi.center.api.remoteservice.settlement;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.settlement.SettlementDetailDto;
import cn.com.duiba.quanyi.center.api.dto.settlement.SettlementDetailSimpleDto;
import cn.com.duiba.quanyi.center.api.param.settlement.SettlementDetailSearchParam;
import java.util.List;

/**
 * 结算单明细
 * @author kjj mybatis generator 
 * @date 2024-11-30
 */
@AdvancedFeignClient
public interface RemoteSettlementDetailService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 结算单明细集合
     */
    List<SettlementDetailSimpleDto> selectSimplePage(SettlementDetailSearchParam param);
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 结算单明细集合
     */
    List<Long> selectIdPage(SettlementDetailSearchParam param);

    /**
     * 批量新增
     * @param list 结算单明细
     * @return 执行结果
     */
    int batchInsert(List<SettlementDetailDto> list);

    /**
     * 批量删除
     * @param ids 主键
     * @return 执行结果
     */
    int batchDelete(List<Long> ids);
}