package cn.com.duiba.quanyi.center.api.enums.activity;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Objects;

/**
 * @author nongfu
 * @Date 2024/7/30 15:12
 */
@Getter
@AllArgsConstructor
public enum TemplateWhiteStandEnum {

    COMMON_STANDARD(0, "通用达标默认不实现", null),
    CLIENT_STANDARD(1, "客户号达标", TemplateWhiteRecordQueryFieldEnum.CLIENT_NUMBER),
    PHONE_STANDARD(2, "手机号达标", TemplateWhiteRecordQueryFieldEnum.MOBILE),
    BOC_BANK_CLIENT_STANDARD(3, "中行网银客户号达标", TemplateWhiteRecordQueryFieldEnum.CLIENT_NUMBER),
    BOC_CORE_CLIENT_STANDARD(4, "中行核心客户号达标", TemplateWhiteRecordQueryFieldEnum.CLIENT_NUMBER);

    public static TemplateWhiteStandEnum getEnumByType(Integer type) {
        for (TemplateWhiteStandEnum typeEnum : values()) {
            if (Objects.equals(typeEnum.getType(), type)) {
                return typeEnum;
            }
        }
        return COMMON_STANDARD;
    }

    private final Integer type;

    private final String desc;

    private final TemplateWhiteRecordQueryFieldEnum whiteRecordQueryFieldEnum;
}

