package cn.com.duiba.quanyi.center.api.param.bank.zgbank;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import java.io.Serializable;
import java.util.Date;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 中国银行对账记录表
 * @author mybatis generator 
 * @date 2024-10-30
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class ZgbankSettleRecordSearchParam extends PageQuery implements Serializable {
     
    private static final long serialVersionUID = 17302687157084507L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 兑吧触发对账日期
     */
    private String curDate;

    /**
     * 对账周期
     */
    private String settlementDt;

    /**
     * 1 上传  2 重试中
     */
    private Integer billUploadStatus;

    /**
     * 对账周期明细 1 未下载  2 已下载
     */
    private Integer settleDownloadStatus;

    /**
     * 结算单下载状态 1 未下载 2、已下载
     */
    private Integer settlementDownloadStatus;

    /**
     * 对账周期明细结果 0 未处理 1 通过 2不通过
     */
    private Integer settleCheckResult;

    /**
     * 结算单结果 0 未处理  1通过 2不通过
     */
    private Integer settlementCheckResult;

    /**
     * 对账周期明细结果 0 未通知 1已通知
     */
    private Integer settleIsNotify;

    /**
     * 结算单结果 0 未通知  1已通知
     */
    private Integer settlementIsNotify;

    /**
     * 对账方案编号
     */
    private String settlePlanNo;


    /**
     * 结算单编号
     */
    private String settlementNo;
}