package cn.com.duiba.quanyi.center.api.param.common;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import java.io.Serializable;
import java.util.Date;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 通用业务关联表
 * @author mybatis generator 
 * @date 2025-03-05
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class CommonBizRelationSearchParam extends PageQuery implements Serializable {
     
    private static final long serialVersionUID = 1741174078119160L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 是否逻辑删除, 0-未删除, 1-已删除
     */
    private Integer logicDelete;

    /**
     * 删除时间
     */
    private Date logicDeleteTime;

    /**
     * 业务关联id 1-客户id
     */
    private Long bizRelationId;

    /**
     * 业务id 1-api对接id
     */
    private Long bizId;

    /**
     * 创建人id
     */
    private Long creatorId;

    /**
     * 创建人姓名
     */
    private String creatorName;

    /**
     * 业务类型 1-共享客户
     */
    private Integer bizType;

    /**
     * 业务扩展信息
     */
    private String bizJson;
}