package cn.com.duiba.quanyi.center.api.enums.activity;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author nongfu
 * @Date 2024/6/21 13:44
 */

@Getter
@AllArgsConstructor
public enum ActivityTagEnum {
    COMMON("common", "定制类通用活动可不选", ActivityTagTypeEnum.ACTIVITY_TAG.getTagType()),
    HN_ABC_BIRTHDAY("hnabcsrl", "湖南长沙农行生日礼", ActivityTagTypeEnum.ACTIVITY_TAG.getTagType()),
    HN_ABC_PROMOTION("hnabcjjl", "湖南长沙农行晋级礼", ActivityTagTypeEnum.ACTIVITY_TAG.getTagType()),
    HN_ABC_PROMOTE("hnabctsl", "湖南长沙农行提升礼", ActivityTagTypeEnum.ACTIVITY_TAG.getTagType()),
    HN_ABC_EXCLUSIVE("hnabczxl", "湖南长沙农行尊享礼", ActivityTagTypeEnum.ACTIVITY_TAG.getTagType()),
    HN_ABC_SHARE("hnabcfxl", "湖南长沙农行分享礼", ActivityTagTypeEnum.ACTIVITY_TAG.getTagType()),

    ABC_HN_LD_BANK_STANDARD("abchnsign", "湖南活动只判断上月报名的统一走这个", ActivityTagTypeEnum.ACTIVITY_TAG.getTagType()),
    ABC_HN_LD_BANK_INVITE("abchnldyql", "湖南娄底邀请礼", ActivityTagTypeEnum.ACTIVITY_TAG.getTagType()),
    ABC_HN_ZZ_BIRTHDAY("nhhnzzsrl", "农行湖南株洲生日礼", ActivityTagTypeEnum.ACTIVITY_TAG.getTagType()),
    ABC_HN_ZZ_BIRTHDAY_SHARE("nhhnzzsrfxl", "农行湖南株洲生日分享礼", ActivityTagTypeEnum.ACTIVITY_TAG.getTagType()),
    ABC_HN_ZZ_PROMOTE("nhhnzztsl", "农行湖南株洲提升礼", ActivityTagTypeEnum.ACTIVITY_TAG.getTagType()),
    BOC_SH_NEW_CUSTOMER_JJG("shzhxkjjg", "上海中行新客节节高", ActivityTagTypeEnum.ACTIVITY_TAG.getTagType()),
    BOC_SH_NEW_CUSTOMER_RISING_GOLD("shzhxksj", "上海中行新客升金", ActivityTagTypeEnum.ACTIVITY_TAG.getTagType()),
    BOC_FJ_PROVIDE_BENEFIT("fjzhffdd", "福建中行发福地段", ActivityTagTypeEnum.ACTIVITY_TAG.getTagType()),
    BOC_FJ_PAYMENT_AGENCY("fjzhdfx", "直接领取只展示能领取的奖励(仅限中行)", ActivityTagTypeEnum.ACTIVITY_TAG.getTagType()),
    BOC_YN_STANDARD_RECEIVE("ynzhdbzl", "云南中行达标直领", ActivityTagTypeEnum.ACTIVITY_TAG.getTagType()),
    BOC_HB_STANDARD_ACTIVITY("bochbstandard", "湖北中行达标礼", ActivityTagTypeEnum.ACTIVITY_TAG.getTagType()),
    BOC_BJ_SOCIAL_SECURITY_CARD_KKL("bjzhsbkzqkkl", "北京中行社保卡专区开卡礼", ActivityTagTypeEnum.ACTIVITY_TAG.getTagType()),
    BOC_BJ_SOCIAL_SECURITY_CARD_TYYHL("bjzhsbkzqtyyhl", "北京中行社保卡专区特邀用户礼", ActivityTagTypeEnum.ACTIVITY_TAG.getTagType()),
    BOC_BJ_SOCIAL_SECURITY_CARD_KKBLL("bjzhsbkzqkkbll", "北京中行社保卡专区开卡补领礼", ActivityTagTypeEnum.ACTIVITY_TAG.getTagType()),
    BOC_BJ_SOCIAL_SECURITY_CARD_JJL("bjzhsbkzqjhl", "北京中行社保卡专区激活礼", ActivityTagTypeEnum.ACTIVITY_TAG.getTagType()),
    BOC_BJ_SSOCIAL_SECURITY_CARD_JHBLL("bjzhsbkzqjhbll", "北京中行社保卡专区激活补领礼", ActivityTagTypeEnum.ACTIVITY_TAG.getTagType()),
    BOC_GD_HYYHL("gdhyyhl", "广东中行活跃有好礼", ActivityTagTypeEnum.ACTIVITY_TAG.getTagType()),
    BOC_QD_MONTH_GIFT_NEW_ACTIVITY("bocqdmonthnewgift", "青岛中行月月礼-新客活动", ActivityTagTypeEnum.ACTIVITY_TAG.getTagType()),
    BOC_QD_MONTH_GIFT_UN_NEW_ACTIVITY("bocqdmonthunnewgift", "青岛中行月月礼-非新客活动", ActivityTagTypeEnum.ACTIVITY_TAG.getTagType()),
    BOC_QD_INVITED_CUSTOMER_ACTIVITY("bocqdinvitedcustomeRgift", "青岛中行-受邀客户专享活动", ActivityTagTypeEnum.ACTIVITY_TAG.getTagType()),
    BOC_TJ_SOCIAL_SECURITY_CARD("tjzhsdsbk", "天津中行三代社保卡", ActivityTagTypeEnum.ACTIVITY_TAG.getTagType()),
    BOC_HENAN_STEP_HIGH("henanzhbbgs", "河南中行步步高升", ActivityTagTypeEnum.ACTIVITY_TAG.getTagType()),
    BOC_ZJ_LS_NEW_CLIENT("zjlszhxkhd", "浙江丽水中行新客活动", ActivityTagTypeEnum.ACTIVITY_TAG.getTagType()),
    BOC_ZJ_WHITE_LIST("zjzhbmdhd", "浙江中行白名单活动", ActivityTagTypeEnum.ACTIVITY_TAG.getTagType()),
    BOC_SZ_ASSET_ENHANCEMENT_ACTIVITY("szzhzctsl", "苏州中行资产提升礼活动", ActivityTagTypeEnum.ACTIVITY_TAG.getTagType()),
    BOC_ZJ_TURNTABLE_ACTIVITY("zhzjfhzldzp", "中行浙江分行浙里大转盘", ActivityTagTypeEnum.ACTIVITY_TAG.getTagType()),
    BOC_ZJ_TYFL_ACTIVITY("zhzjfhtyfl", "中行浙江分行特邀福利", ActivityTagTypeEnum.ACTIVITY_TAG.getTagType()),
    BOC_ZJ_KA_BU("zjzhkbdb", "浙江中行卡部达标领奖", ActivityTagTypeEnum.ACTIVITY_TAG.getTagType()),
    BOC_NB_STANDARD_ACTIVITY("nbzhdb", "宁波中行达标活动", ActivityTagTypeEnum.ACTIVITY_TAG.getTagType()),
    BOC_NB_FISSION_ACTIVITY("bocnblb", "宁波中行裂变活动", ActivityTagTypeEnum.ACTIVITY_TAG.getTagType()),
    BOC_NB_CRED_WHITE_ACTIVITY("nbzhcredwhite", "宁波中行客户号接口达标活动", ActivityTagTypeEnum.ACTIVITY_TAG.getTagType()),
    BOC_QD_INVITE_GIFT_ACTIVITY("bocqdinvitegift", "青岛中行受邀礼", ActivityTagTypeEnum.ACTIVITY_TAG.getTagType()),
    BOC_BJ_FULL_OF_SURPRISE_ACTIVITY("bocbjfullofsurprise", "北京中行惊喜重重专区活动",ActivityTagTypeEnum.ACTIVITY_TAG.getTagType()),
    BOC_HBZH_WHITE_ACTIVITY("hbzhwhite", "湖北中行白名单领奖", ActivityTagTypeEnum.ACTIVITY_TAG.getTagType()),
            ;

    /**
     * 活动标签
     */
    private final String activityTag;

    /**
     * 描述
     */
    private final String desc;

    /**
     * 标签类型
     */
    private final String tagType;

}
