package cn.com.duiba.quanyi.center.api.remoteservice.demand.task;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.demand.task.ChangeSkuTaskDto;
import cn.com.duiba.quanyi.center.api.enums.demand.ChangeSkuTaskStatusEnum;

/**
 * 批量更换供应商操作任务表
 * @author kjj mybatis generator 
 * @date 2025-02-17
 */
@AdvancedFeignClient
public interface RemoteChangeSkuTaskService {

    /**
     * 新增
     * @param dto 批量更换供应商操作任务
     * @return 执行结果
     */
    Long insert(ChangeSkuTaskDto dto);

    /**
     * 根据id更新任务状态
     * @param id 主键id
     * @param fromStatus 原状态
     * @param toStatus 更改后的状态
     * @see ChangeSkuTaskStatusEnum
     * @return 更新数量
     */
    int updateTaskStatus(Long id, Integer fromStatus, Integer toStatus);
}