package cn.com.duiba.quanyi.center.api.dto.insurance.car;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 车险结算材料
 * @author mybatis generator 
 * @date 2025-03-07
 */
@Data
public class CarInsuranceSettlementMaterialsDto implements Serializable {
     
    private static final long serialVersionUID = 17413278027096123L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;

    /**
     * 操作人Id
     */
    private Long operatorId;

    /**
     * 操作人姓名
     */
    private String operatorName;

    /**
     * 顶部标题
     */
    private String topTitle;

    /**
     * 文章标题
     */
    private String articleTitle;

    /**
     * 顶部海报URL
     */
    private String topPosterUrl;

    /**
     * 文本内容
     */
    private String textContent;

    /**
     * 阅读量
     */
    private String readCount;

    /**
     * 发布时间
     */
    private Date publishTime;

    /**
     * 链接地址
     */
    private String linkAddress;

    /**
     * 是否启用：0-停用 1-启用
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum
     */
    private Integer enable;

    /**
     * 是否逻辑删除, 0-未删除, 1-已删除
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum
     */
    private Integer logicDelete;
}