package cn.com.duiba.quanyi.center.api.enums.external;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 外部订单-公共字段-订单类型枚举
 *
 * @author lizhi
 * @date 2024/12/16 13:55
 */
@AllArgsConstructor
@Getter
public enum ExternalOrderTransactionTypeEnum {
    REFUND( 0,"退款"),
    PAYMENT(1,"支付"),
    ;
    private final Integer code;

    private final String desc;

    /**
     * 根据desc 获取code
     */
    public static Integer getCodeByDesc(String desc) {
        for (ExternalOrderTransactionTypeEnum typeEnum : ExternalOrderTransactionTypeEnum.values()) {
            if (typeEnum.getDesc().equals(desc)) {
                return typeEnum.getCode();
            }
        }
        return null;
    }

}
