package cn.com.duiba.quanyi.center.api.dto.activity.common.cache;

import cn.com.duiba.quanyi.center.api.dto.pay.PayOrderDto;
import cn.com.duiba.quanyi.center.api.dto.user.UserDto;
import lombok.Data;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * @author lizhi
 * @date 2025/4/14 16:47
 */
@Data
public class ActivityCommonUserInfoCacheDto implements Serializable {
    
    private static final long serialVersionUID = -5248072315758299658L;

    /**
     * 领取记录
     */
    private List<ActivityPrizeReceiveRecordCacheDto> receiveRecordList;

    /**
     * 用户
     */
    private UserDto userDto;

    /**
     * 用户扩展信息缓存
     */
    private Map<Integer, String> userExtMap;

    /**
     * 用户身份校验结果（API）
     */
    private ActivityCommonUserApiVerifyDto userApiVerify;

    /**
     * 用户身份校验结果（定制校验）
     */
    private ActivityCommonUserCustomVerifyDto userCustomVerify;

    /**
     * 达标等级（API）
     */
    private ActivityCommonReachStandardDto apiReachStandard;

    /**
     * 报名记录
     */
    private List<ActivitySignUpCacheDto> signUpList;

    /**
     * 最近一次支付记录
     */
    private PayOrderDto lastPayOrder;
    
    /**
     * 支付后可领取的奖品/次数--
     */
    private List<PayOrderTakeVoucherCacheDto> payOrderPrizeList;
}
