package cn.com.duiba.quanyi.center.api.dto.activity.common.ext;

import lombok.Data;

import java.io.Serializable;

/**
 * @author lizhi
 * @date 2025/4/22 18:09
 */
@Data
public class ActivityCommonPayConfDto implements Serializable {
    
    private static final long serialVersionUID = -4107259846801949348L;

    /**
     * 是否启用
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum
     */
    private Integer enable;

    /**
     * 维度
     * @see cn.com.duiba.quanyi.center.api.enums.activity.common.ActivityCommonDimensionEnum
     */
    private Integer dimension;

    /**
     * 支付类型
     * @see cn.com.duiba.quanyi.center.api.enums.activity.common.ActivityCommonPayTypeEnum
     */
    private Integer payType;

    /**
     * 支付渠道
     *
     * @see cn.com.duiba.quanyi.center.api.enums.pay.PayChannelTypeEnum
     */
    private String payChannelType;
    
    /**
     * 是否限制卡Bin，0-否，1-是
     * 目前支持：微信支付、支付宝支付
     */
    private Integer needLimitCardBin;

    /**
     * 优惠标记（微信支付需要填写）
     */
    private String goodsTag;
    
    /**
     * 确认弹窗辅助文案（微信、支付宝）
     */
    private String desc;

    /**
     * 活动纬度金额配置
     */
    private ActivityCommonPayAmountDto activityAmount;

    /**
     * 奖品纬度支付，金额配置
     */
    private ActivityCommonPrizePayAmountDto prizeAmountList;

    /**
     * 是否限制银行卡，0-否，1-是
     * 目前支持：微信支付、中国银行支付（boc_pay）
     *
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum
     */
    private Integer needLimitBank;

    /**
     * 限制的银行卡编码，以英文逗号分隔
     * @see cn.com.duiba.quanyi.center.api.enums.pay.WxPayBankTypeEnum (微信)
     * @see cn.com.duiba.quanyi.center.api.enums.activity.ActivityPayCardTypeEnum （中国银行-boc）
     */
    private String limitBanks;

    /**
     * 是否支付成功后自动退款，0-否，1-是
     *
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum
     */
    private Integer autoRefund;
}
