package cn.com.duiba.quanyi.center.api.dto.activity.common.ext;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author lizhi
 * @date 2025/4/28 10:23
 */
@Data
public class ActivityCommonTimeLimitConfDto implements Serializable {
    
    private static final long serialVersionUID = 1048992100960769910L;

    /**
     * 是否启用
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum
     */
    private Integer enable;

    /**
     * 周期单位
     * @see cn.com.duiba.quanyi.center.api.enums.activity.common.ActivityPeriodicUnitEnum
     */
    private Integer periodicUnit;

    /**
     * 日开始时间（周期单位为：日、周、月、季度时有值）
     * 时间格式 HHmm
     * 默认有值
     */
    private Long dayStartTime;

    /**
     * 日结束时间（周期单位为：日、周、月、季度时有值）
     * 时间格式 HHmm
     * 默认有值
     */
    private Long dayEndTime;

    /**
     * 周限制时间，格式为 1,2,3,4,5,6,7（周期单位为：周 时有值）
     * 1表示周一，7表示周日
     * 多个值用逗号分隔
     * 周限制和月限制互斥
     */
    private String weekLimitByDay;

    /**
     * 月限制开始时间（周期单位为：月 时有值）
     * 时间格式 dd
     */
    private Integer monthStartTimeByDay;

    /**
     * 月限制结束时间（周期单位为：月 时有值）
     * 时间格式 dd
     */
    private Integer monthEndTime;

    /**
     * 绝对时间，时间区间
     */
    private List<ActivityCommonTimeLimitAbsoluteConfDto> absoluteTimeList;
}
