package cn.com.duiba.quanyi.center.api.dto.activity.common.result;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author lizhi
 * @date 2025/4/22 09:52
 */
@Data
public class ActivityCommonUserResultDto implements Serializable {
    
    private static final long serialVersionUID = 3824015657716216990L;

    /**
     * 活动是否可以领取
     */
    private boolean canTake;

    /**
     * 活动纬度不能领取的异常编码
     */
    private String canNotTakeCode;

    /**
     * 是否限制中奖次数
     */
    private Integer takeNumLimit;

    /**
     * 活动纬度剩余领取次数
     */
    private Long surplusNum;

    /**
     * 活动纬度当前是否可以支付
     */
    private boolean canPay;

    /**
     * 是否需要报名
     */
    private boolean needSignUp;

    /**
     * 作为邀请者时被助力次数
     */
    private long inviterHelpedTimes;

    /**
     * 作为被邀请者时已助力次数
     */
    private long inviteeHelpedTimes;

    /**
     * 奖品列表
     */
    private List<ActivityCommonUserPrizeResultDto> prizeList;

}
