package cn.com.duiba.quanyi.center.api.dto.activity.common.take;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author lizhi
 * @date 2025/4/22 15:36
 */
@Data
public class ActivityCommonPrizeTakeDto implements Serializable {
    
    private static final long serialVersionUID = -6932084844210600148L;

    /**
     * 奖品ID
     */
    private Long prizeId;

    /**
     * 用户领取统计数据表ID
     */
    private Long userTakeStatId;

    /**
     * 奖品维度已领取数量，用于校验领取记录并发写入
     */
    private Long takeCount;

    /**
     * 最后一次领取记录ID，用于校验领取记录并发写入
     */
    private Long lastRecordId;

    /**
     * 不定额发放金额-奖品是不定额时生效
     */
    private Long grantAmount;

    /**
     * 奖品维度 白名单ID，grantAmount不为空时必须传，且白名单中校验发放金额
     */
    private Long whiteListId;

    /**
     * 支付凭证ID
     */
    private Long payOrderTakeVoucherId;

    /**
     * 已领取次数
     */
    private Long payOrderTakeVoucherTakeCount;

    /**
     * 领取记录ID，英文逗号分隔
     */
    private String payOrderTakeVoucherRecordIds;

    /**
     * 支付单号
     */
    private String bizOrderNo;

    /**
     * 子奖品（仅当前prizeId为券包奖品时有效）
     */
    private List<ActivityCommonSubPrizeTakeDto> subPrizeList;
}
