package cn.com.duiba.quanyi.center.api.dto.coupon;

import cn.com.duiba.quanyi.center.api.enums.activity.BankEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

/**
 * 微信立减金表
 *
 * @author kjj mybatis generator
 * @date 2023-08-07
 */
@Data
public class WxCouponDto implements Serializable {


    private static final long serialVersionUID = 7862341555892038169L;
    /**
     * 主键
     */
    private Long id;

    /**
     * 微信批次号
     */
    private String stockId;

    /**
     * 微信批次名称
     */
    private String stockName;

    /**
     * 发券商户ID
     */
    private String mchId;

    /**
     * 创建批次的商户号
     */
    private String stockCreatorMchId;

    /**
     * 总预算，单位分
     */
    private Long maxAmount;

    /**
     * 面额，单位分
     */
    private Long couponAmount;

    /**
     * 使用券金额门槛，单位分
     */
    private Long transactionMinimum;

    /**
     * 批次创建时间
     */
    private Date createTime;

    /**
     * 批次状态
     * @see cn.com.duiba.quanyi.center.api.enums.coupon.WxStockStatusEnum#getStatus()
     */
    private String stockStatus;

    /**
     * 批次类型
     * @see cn.com.duiba.quanyi.center.api.enums.coupon.WxStockTypeEnum
     */
    private Integer stockType;

    /**
     * 创建人sso id
     */
    private Long createOperatorId;

    /**
     * 创建人
     */
    private String createOperatorName;

    /**
     * 可用开始时间
     */
    private Date availableBeginTime;

    /**
     * 可用结束时间
     */
    private Date availableEndTime;

    /**
     * 合同主键, tb_contract.id
     */
    private Long contractId;

    /**
     * 需求主键, tb_demand.id
     */
    private Long demandId;

    /**
     * 需求商品主键, tb_demand_goods.id
     */
    private Long demandGoodsId;

    /**
     * 商品规格ID
     */
    private Long skuId;

    /**
     * 是否需要告警，0-不需要，1-需要
     *
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum
     */
    private Integer needWarn;

    /**
     * 用户领券后有效期为多少天，用于告警
     */
    private Integer userValidityPeriod;

    /**
     * 业务状态
     * @see cn.com.duiba.quanyi.center.api.enums.coupon.WxStockBizStatusEnum
     */
    private Integer bizStatus;

    /**
     * 已发放金额，目前仅固定面额可计算得出该值，-1代表无法计算
     */
    private Long distributedAmount;

    /**
     * 已发放天数
     */
    private Integer distributedDay;

    /**
     * 总发放天数
     */
    private Integer maxDay;

    /**
     * 资金使用率，-1代表无法计算
     */
    private Integer fundUseRate;

    /**
     * 面额类型：1-固定，2-不固定
     * @see cn.com.duiba.quanyi.center.api.enums.coupon.AmountTypeEnum#getType()
     */
    private Integer amountType;

    /**
     * 不固定面额：最小面额，单位分
     */
    private Long rangeMinAmount;

    /**
     * 不固定面额：最大面额，单位分
     */
    private Long rangeMaxAmount;

    /**
     * 是否逻辑删除, 0-未删除, 1-已删除
     *
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum
     */
    private Integer logicDelete;


    /**
     * 银行名称类型（可为空）
     * @see BankEnum ;
     */
    private String bankName;

    /**
     * 银行卡片类型
     * @see cn.com.duiba.quanyi.center.api.enums.pay.BankCardTypeEnum;
     */
    private String bankCardType;

    /**
     * 单个用户可领个数
     * 说明：单个用户可领个数，每个用户最多100张券
     * 示例值：3
     * 必填，uint32
     */
    private Integer maxCouponsPerUser;

    /**
     * 预算金额 分
     */
    private Long budgetAmount;

    /**
     * 是否需要自动加款 0-不需要 1-需要
     */
    private Integer autoAddMoney;

    /**
     * 是否自动创建 0-否 1-是
     */
    private Integer autoCreate;

    /**
     * 立减金实际发放周期（天）
     */
    private Integer stockDistributePeriod;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;


    /**
     * 是否启用，0-不启用，1启用
     *
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum
     */
    private Integer enableStatus;

    /**
     * 实际每日发放上限金额 单位分
     */
    private Long maxAmountByDay;

    /**
     * 公司名称
     */
    private String companyName;

    /**
     * 结算主体
     */
    private String settlementEntity;

    /**
     * 结算价
     */
    private String settlementRate;

    /**
     * 运营负责人名称
     */
    private String operationManagerName;

    /**
     * 预设每日发放上限金额 单位分
     */
    private Long dayLimitAmount;

    /**
     * 退款结算截止日
     */
    private Integer settlementDeadlineDays;

    /**
     * 退款结算类型
     * @see cn.com.duiba.quanyi.center.api.enums.coupon.SettlementDeadlineTypeEnum
     */
    private Integer settlementDeadlineType;

    /**
     * 自定义退款截止日
     */
    private Date settlementDeadlineTime;


    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        WxCouponDto wxCoupon = (WxCouponDto) o;
        return stockId.equals(wxCoupon.stockId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(stockId);
    }
}