package cn.com.duiba.quanyi.center.api.enums.activity;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

/**
 * @author yangyukang
 */

@Getter
@AllArgsConstructor
public enum ActivityPrizeExtEnum {

    SUPPLY_WX_APPIDS(1, "微信appid(,分割)"),
    COUPON_TIME_LIMIT_TYPE(2, "限制批次发放时间：0-不限定，1-限定"),

    SHORT_URL_EFFECTIVE_DAYS(3, "短链有效天数"),

    CROSSED_PRICE(4,"划线价"),

    SELLING_PRICE(5,"销售价"),

    USER_RULES(6,"奖品使用规则"),

    CREDITS_PRIZE(7,"积分兑换价格"),
    PAY_AMOUNT(8, "奖品支付价格"),


    EQUITY_PRICE(9, "权益定价"),

    EQUITY_VALID_DAYS(10, "权益有效期"),
    EQUITY_UNION_CODE_LIST(11, "支持的权益服务编码，英文逗号分隔"),


    EQUITY_TOTAL_TAKE_NUM(12, "可兑换次数"),
    EQUITY_SINGLE_TAKE_NUM_LIMIT(13, "单个奖品是否限制兑换次数"),

    EQUITY_SINGLE_TAKE_NUM(14, "单个奖品可兑换次数"),
    GOODS_SETTLEMENT_PRICE(15, "商品结算价格"),
    RULE_IMG(16, "规则图"),

    // 邮储定制
    MERCHANT_NO(17, "商户编号"),
    // 京东金融定制
    BEFORE_TAX_AMOUNT(18, "税前价格（单位分）"),
    ACTUAL_GRANT_AMOUNT(19, "实际发放金额（单位分）"),
    NON_FIXED_AMOUNT_DEDUCTION(22, "不定额立减金"),
    // 邮储自动塞券
    API_SUPPLY_EXCLUDED_PRIZE(20, "API供货发放排除此奖品"),
    AUTO_GRANT_CONTINUOUS_DAYS(21, "自动塞券持续天数"),
    SHORT_URL_EFFECTIVE_DAYS_BY_PRIZE(23, "供货短链过期时间"),
    
    /**
     * @see cn.com.duiba.quanyi.center.api.dto.activity.common.ext.ActivityCommonTakeLimitConfDto
     */
    TAKE_NUM_LIMIT(24, "用户领奖限制"),

    /**
     * @see cn.com.duiba.quanyi.center.api.dto.activity.common.ext.ActivityCommonPrizeStockLimitConfDto
     */
    STOCK_LIMIT(25, "库存发放限制"),
    ;

    /**
     * 定制类型
     */
    private static final Set<Integer> CUSTOM_TYPE_SET = Collections.unmodifiableSet(new HashSet<>(Arrays.asList(
            MERCHANT_NO.getType(),
            BEFORE_TAX_AMOUNT.getType(),
            ACTUAL_GRANT_AMOUNT.getType(),
            API_SUPPLY_EXCLUDED_PRIZE.getType(),
            AUTO_GRANT_CONTINUOUS_DAYS.getType()
    )));

    private final Integer type;

    private final String desc;

    public static boolean isCustomExt(Integer type) {
        if (type == null) {
            return false;
        }
        return CUSTOM_TYPE_SET.contains(type);
    }

}
