package cn.com.duiba.quanyi.center.api.enums.coupon.autocreate.alipay;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author xuzhigang
 * @date 2024/9/5 18:25
 **/
@Getter
@AllArgsConstructor
public enum DiscountTypeEnum {
    FIXED_AMOUNT_DISCOUNT(1, "定额满减"),

    RANDOM_DISCOUNT(2, "随机满减"),
    ;

    private final Integer type;

    private final String desc;

    public static DiscountTypeEnum getByType(Integer type) {
        for (DiscountTypeEnum item : values()) {
            if (item.type.equals(type)) {
                return item;
            }
        }
        return null;
    }
}
