package cn.com.duiba.quanyi.center.api.enums.demand;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author lizhi
 * @date 2024/10/21 17:42
 */
@AllArgsConstructor
@Getter
public enum MainStatusEnum {
    NOT_COMMIT(1, "待提交",Boolean.FALSE),
    COMMIT_FAIL(2, "提交失败",Boolean.FALSE),
    RUNNING(3, "审核中",Boolean.TRUE),
    WAIT_PAY(4, "待付款",Boolean.TRUE),

    TERMINATED(5, "已撤回",Boolean.TRUE),
    REFUSE(6, "已拒绝",Boolean.TRUE),
    AGREE(7, "已完成",Boolean.TRUE),
    DELETE(8, "已删除",Boolean.TRUE),
    ;
    
    private final Integer status;
    
    private final String desc;

    /**
     * 是否显示
     */
    private final Boolean show;

    private static final Map<Integer, MainStatusEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(MainStatusEnum::getStatus, Function.identity(), (v1, v2) -> v2)));

    /**
     * 财务可见状态
     */
    private static final Set<Integer> FINANCE_SHOW_STATUS = Collections.unmodifiableSet(new HashSet<>(Arrays.asList(
            WAIT_PAY.getStatus(),
            TERMINATED.getStatus(),
            REFUSE.getStatus(),
            AGREE.getStatus(),
            DELETE.getStatus()
    )));

    public static Set<Integer> getFinanceShowStatus() {
        return FINANCE_SHOW_STATUS;
    }
    /**
     * 根据枚举值获取枚举
     * @param status 枚举值
     * @return 枚举
     */
    public static MainStatusEnum getByStatus(Integer status) {
        if (status == null) {
            return null;
        }
        return ENUM_MAP.get(status);
    }
}
