package cn.com.duiba.quanyi.center.api.enums.settlement;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author lizhi
 * @date 2024/11/25 16:28
 */
@AllArgsConstructor
@Getter
public enum InvoiceStatusEnum {
    PENDING_INVOICING(1, "待开票"),
    INVOICED(2, "已开票"),
    INVOICE_RED_OFFSET_APPROVAL(3, "红冲审批中"),
    INVOICE_RED_OFFSET(4, "已红冲"),
    ;

    private static final Map<Integer, InvoiceStatusEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(InvoiceStatusEnum::getStatus, Function.identity(), (v1, v2) -> v2)));

    private final Integer status;
    
    private final String desc;

    /**
     * 根据枚举值获取枚举
     * @param status 枚举值
     * @return 枚举
     */
    public static InvoiceStatusEnum getByStatus(Integer status) {
        if (status == null) {
            return null;
        }
        return ENUM_MAP.get(status);
    }
}
