package cn.com.duiba.quanyi.center.api.param.activity;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.io.Serializable;

/**
 * 活动黑白名单表
 * @author mybatis generator 
 * @date 2025-04-15
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class ActivityBlackWhiteListSearchParam extends PageQuery implements Serializable {
     
    private static final long serialVersionUID = 17446989970573094L;

    /**
     * 是否逻辑删除, 0-未删除, 1-已删除
     */
    private Integer logicDelete;

    /**
     * 类型：1-白名单，2-黑名单
     */
    private Integer listType;

    /**
     * 活动主键, tb_activity.id
     */
    private Long activityId;

    /**
     * 用户唯一标记
     */
    private String userMark;

    /**
     * 奖品ID
     */
    private Long prizeId;

    /**
     * 添加名单的操作人类型，1-内部sso用户，2-合作方员工
     */
    private Integer operatorType;

    /**
     * 添加人Id
     */
    private Long operatorId;
}