package cn.com.duiba.quanyi.center.api.param.ali.travel;

import cn.com.duiba.quanyi.center.api.enums.pay.PayChannelTypeEnum;
import lombok.Data;

import java.io.Serializable;

/**
 * @author nongfu
 * @Date 2024/5/7 10:33
 */
@Data
public class RemoteAliTravelPayParam implements Serializable {

    private static final long serialVersionUID = -8270465575968660503L;
    /**
     * 活动ID
     */
    private Long activityId;
    /**
     * 活动类型
     */
    private Integer activityType;

    /**
     * 用户ID
     */
    private Long userId;

    /**
     * 小程序appId
     */
    private String appId;

    /**
     * 页面展示需要支付的金额
     */
    private Long pageAmount;

    /**
     * 支付商品名称
     */
    private String goodsName;
    /**
     * 用户手机号
     */
    private String userPhone;

    /**
     * 支付渠道
     * @see cn.com.duiba.quanyi.center.api.enums.pay.PayChannelTypeEnum
     */
    private String payChannelType = PayChannelTypeEnum.ALIPAY_WAP_PAY_FACE.getChannelType();

    /**
     * 业务ID  对应tb_activity_prize_receive_record 主键ID
     */
    private Long bizId;

}
