package cn.com.duiba.quanyi.center.api.remoteservice.activity;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.activity.ActivityPrizeExtDto;
import cn.com.duiba.quanyi.center.api.param.activity.ActivityPrizeExtSearchParam;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 奖品配置配置扩展表
 * @author kjj mybatis generator 
 * @date 2023-12-18
 */
@AdvancedFeignClient
public interface RemoteActivityPrizeExtService {

    /**
     * 根据条件查询，不分页
     * @param param 查询条件
     * @return 奖品配置配置扩展集合
     */
    List<ActivityPrizeExtDto> selectNoPage(ActivityPrizeExtSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 奖品配置配置扩展
     */
    ActivityPrizeExtDto selectById(Long id);

    /**
     * 根据奖品id查询扩展信息
     * @param prizeId 主键
     * @return 奖品配置配置扩展
     */
    Map<Integer, String> selectMapByPrizeId(Long prizeId);

    /**
     * 根据奖品id批量查询扩展信息
     * @param prizeIds
     * @return
     */
    Map<Long, Map<Integer, String>> selectByPrizeIds(Set<Long> prizeIds);

    /**
     * 根据奖品及配置id查询
     * @param prizeId 奖品ID
     * @param confName key
     * @return value
     */
    String selectValueByUk(Long prizeId, Integer confName);

    /**
     * 根据奖品ID和配置名称批量查询
     *
     * @param prizeIds 奖品ID列表
     * @param confName 配置名称
     * @return key：prizeId，value：奖品配置配置扩展
     */
    Map<Long, String> selectMapByPrizeIdsConf(Set<Long> prizeIds, Integer confName);

    /**
     * 根据活动id查询
     *
     * @param activityId 活动ID
     * @return key：奖品ID，key：配置枚举，value：配置的值
     */
    Map<Long, Map<Integer, String>> selectMapByActivityId(Long activityId);


    /**
     * 根据唯一索引批量新增或修改
     * @param entityList 奖品配置扩展
     * @return 执行结果
     */
    int batchSaveOrUpdate(List<ActivityPrizeExtDto> entityList);
}