package cn.com.duiba.quanyi.center.api.remoteservice.activity.assist;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.activity.assist.InviteAssistTimesDto;
import cn.com.duiba.quanyi.center.api.param.activity.assist.InviteAssistTimesSearchParam;
import java.util.List;

/**
 * 邀请助力产生的次数
 * @author kjj mybatis generator 
 * @date 2025-04-15
 */
@AdvancedFeignClient
public interface RemoteInviteAssistTimesService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 邀请助力产生的次数集合
     */
    List<InviteAssistTimesDto> selectPage(InviteAssistTimesSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(InviteAssistTimesSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 邀请助力产生的次数
     */
    InviteAssistTimesDto selectById(Long id);

    /**
     * 新增
     * @param dto 邀请助力产生的次数
     * @return 执行结果
     */
    int insert(InviteAssistTimesDto dto);

    /**
     * 更新
     * @param dto 邀请助力产生的次数
     * @return 影响行数
     */
    int update(InviteAssistTimesDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}