package cn.com.duiba.quanyi.center.api.remoteservice.activity.sign;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.activity.sign.ActivitySignUpDto;
import cn.com.duiba.quanyi.center.api.param.activity.sign.ActivitySignUpSearchParam;
import java.util.List;

/**
 * 活动报名
 * @author kjj mybatis generator 
 * @date 2025-04-15
 */
@AdvancedFeignClient
public interface RemoteActivitySignUpService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 活动报名集合
     */
    List<ActivitySignUpDto> selectPage(ActivitySignUpSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(ActivitySignUpSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 活动报名
     */
    ActivitySignUpDto selectById(Long id);

    /**
     * 新增
     * @param dto 活动报名
     * @return 执行结果
     */
    int insert(ActivitySignUpDto dto);
}