package cn.com.duiba.quanyi.center.api.remoteservice.activity.take;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.activity.take.UserTakeStatDto;
import cn.com.duiba.quanyi.center.api.param.activity.take.UserTakeStatSearchParam;
import java.util.List;

/**
 * 用户领取记录统计
 * @author kjj mybatis generator 
 * @date 2025-04-21
 */
@AdvancedFeignClient
public interface RemoteUserTakeStatService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 用户领取记录统计集合
     */
    List<UserTakeStatDto> selectPage(UserTakeStatSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(UserTakeStatSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 用户领取记录统计
     */
    UserTakeStatDto selectById(Long id);

    /**
     * 新增
     * @param dto 用户领取记录统计
     * @return 执行结果
     */
    int insert(UserTakeStatDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}