package cn.com.duiba.quanyi.center.api.utils.activity;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.quanyi.center.api.dto.activity.ActivityDto;
import cn.com.duiba.quanyi.center.api.dto.activity.ActivityPrizeDto;
import cn.com.duiba.quanyi.center.api.dto.activity.common.detail.ActivityCommonDetailDto;
import cn.com.duiba.quanyi.center.api.dto.activity.common.detail.ActivityCommonPrizeDetailDto;
import cn.com.duiba.quanyi.center.api.dto.activity.common.ext.ActivityCommonBlackConfDto;
import cn.com.duiba.quanyi.center.api.dto.activity.common.ext.ActivityCommonNoticeConfDto;
import cn.com.duiba.quanyi.center.api.dto.activity.common.ext.ActivityCommonPayConfDto;
import cn.com.duiba.quanyi.center.api.dto.activity.common.ext.ActivityCommonPrizeStockLimitConfDto;
import cn.com.duiba.quanyi.center.api.dto.activity.common.ext.ActivityCommonReachStandardConfDto;
import cn.com.duiba.quanyi.center.api.dto.activity.common.ext.ActivityCommonSignUpConfDto;
import cn.com.duiba.quanyi.center.api.dto.activity.common.ext.ActivityCommonTakeLimitConfDto;
import cn.com.duiba.quanyi.center.api.dto.activity.common.ext.ActivityCommonTimeLimitConfDto;
import cn.com.duiba.quanyi.center.api.dto.activity.common.ext.ActivityCommonUserLimitConfDto;
import cn.com.duiba.quanyi.center.api.dto.activity.common.ext.ActivityCommonWhiteConfDto;
import cn.com.duiba.quanyi.center.api.enums.activity.ActivityExtEnum;
import cn.com.duiba.quanyi.center.api.enums.activity.ActivityPrizeExtEnum;
import cn.com.duiba.wolf.utils.BeanUtils;
import cn.com.duiba.wolf.utils.NumberUtils;
import com.alibaba.fastjson.JSON;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @author lizhi
 * @date 2025/4/22 10:52
 */
public class ActivityCommonUtils {
    
    private ActivityCommonUtils() {}
    
    public static void throwBiz(ActivityCommonErrorCodeEnum errorCodeEnum) throws BizException {
        throw new BizException(errorCodeEnum.getDesc()).withCode(errorCodeEnum.name());
    }
    
    public static ActivityCommonDetailDto convertDetail(ActivityDto activityDto, Map<Integer, String> activityExtMap, List<ActivityPrizeDto> prizeList, Map<Long, Map<Integer, String>> prizeExtMap) throws BizException {
        if (activityDto == null) {
            throwBiz(ActivityCommonErrorCodeEnum.AC000003);
        }
        if (MapUtils.isEmpty(activityExtMap)) {
            throwBiz(ActivityCommonErrorCodeEnum.AC000004);
        }
        if (CollectionUtils.isEmpty(prizeList)) {
            throwBiz(ActivityCommonErrorCodeEnum.AC000005);
        }
        if (MapUtils.isEmpty(prizeExtMap)) {
            throwBiz(ActivityCommonErrorCodeEnum.AC000006);
        }
        ActivityCommonDetailDto detailDto = BeanUtils.copy(activityDto, ActivityCommonDetailDto.class);
        detailDto.setDrawType(getIntegerByExt(activityExtMap, ActivityExtEnum.PRIZE_DRAW_TYPE.getType()));
        detailDto.setSkinId(activityExtMap.get(ActivityExtEnum.SKIN_ID.getType()));
        detailDto.setSubType(getIntegerByExt(activityExtMap, ActivityExtEnum.COMMON_SUB_TYPE.getType()));
        detailDto.setUserLimit(getObjByExt(activityExtMap, ActivityExtEnum.COMMON_USER_LIMIT.getType(), ActivityCommonUserLimitConfDto.class));
        detailDto.setTimeLimit(getObjByExt(activityExtMap, ActivityExtEnum.COMMON_TAKE_OPEN_TIME_LIMIT.getType(), ActivityCommonTimeLimitConfDto.class));
        detailDto.setTakeNumLimit(getObjByExt(activityExtMap, ActivityExtEnum.COMMON_TAKE_TIMES_LIMIT.getType(), ActivityCommonTakeLimitConfDto.class));
        detailDto.setWhiteConf(getObjByExt(activityExtMap, ActivityExtEnum.COMMON_WHITE_LIST.getType(), ActivityCommonWhiteConfDto.class));
        detailDto.setBlackConf(getObjByExt(activityExtMap, ActivityExtEnum.COMMON_BLACK_LIST.getType(), ActivityCommonBlackConfDto.class));
        detailDto.setReachStandardConf(getObjByExt(activityExtMap, ActivityExtEnum.COMMON_REACH_STANDARD.getType(), ActivityCommonReachStandardConfDto.class));
        detailDto.setPayConf(getObjByExt(activityExtMap, ActivityExtEnum.COMMON_PAY_CONF.getType(), ActivityCommonPayConfDto.class));
        detailDto.setSignUpConf(getObjByExt(activityExtMap, ActivityExtEnum.COMMON_SIGN_UP.getType(), ActivityCommonSignUpConfDto.class));
        detailDto.setEnableStore(getIntegerByExt(activityExtMap, ActivityExtEnum.COMMON_STORE_CONF.getType()));
        detailDto.setNoticeConf(getObjByExt(activityExtMap, ActivityExtEnum.COMMON_NOTICE_CONF.getType(), ActivityCommonNoticeConfDto.class));
        detailDto.setPrizeList(buildPrizeDetail(prizeList, prizeExtMap));
        return detailDto;
    }
    
    private static List<ActivityCommonPrizeDetailDto> buildPrizeDetail(List<ActivityPrizeDto> prizeList, Map<Long, Map<Integer, String>> prizeExtMap) throws BizException {
        List<ActivityCommonPrizeDetailDto> list = new ArrayList<>();
        for (ActivityPrizeDto prizeDto : prizeList) {
            ActivityCommonPrizeDetailDto detailDto = buildPrizeDetail(prizeDto, prizeExtMap.get(prizeDto.getId()));
            list.add(detailDto);
        }
        return list;
    }
    
    private static ActivityCommonPrizeDetailDto buildPrizeDetail(ActivityPrizeDto prizeDto, Map<Integer, String> extMap) throws BizException {
        ActivityCommonPrizeDetailDto detailDto = BeanUtils.copy(prizeDto, ActivityCommonPrizeDetailDto.class);
        detailDto.setTakeNumLimit(getObjByExt(extMap, ActivityPrizeExtEnum.TAKE_NUM_LIMIT.getType(), ActivityCommonTakeLimitConfDto.class));
        detailDto.setStockLimit(getObjByExt(extMap, ActivityPrizeExtEnum.STOCK_LIMIT.getType(), ActivityCommonPrizeStockLimitConfDto.class));
        return detailDto;
    }

    private static Integer getIntegerByExt(Map<Integer, String> extMap, Integer confName) throws BizException {
        if (MapUtils.isEmpty(extMap)) {
            return null;
        }
        String val = extMap.get(confName);
        if (StringUtils.isBlank(val)) {
            return null;
        }
        if (!NumberUtils.isNumeric(val)) {
            throwBiz(ActivityCommonErrorCodeEnum.AC000008);
        }
        return Integer.parseInt(val);
    }

    private static <T> T getObjByExt(Map<Integer, String> extMap, Integer confName, Class<T> clazz) throws BizException {
        if (MapUtils.isEmpty(extMap)) {
            return null;
        }
        String val = extMap.get(confName);
        if (StringUtils.isBlank(val)) {
            return null;
        }
        return JSON.parseObject(val, clazz);
    }
    
//    public static ActivityCommonUserResultDto compute(ActivityCommonDetailDto detailDto, ActivityCommonUserInfoDto userInfoDto) throws BizException {
//        if (detailDto == null) {
//            throwBiz(ActivityCommonErrorCodeEnum.AC000001);
//        }
//        if (userInfoDto == null) {
//            throwBiz(ActivityCommonErrorCodeEnum.AC000002);
//        }
//        ActivityPrizeDrawTypeEnum drawType = getDrawType(detailDto);
//        if (drawType.equals(ActivityPrizeDrawTypeEnum.PROBABILITY)) {
//            // 概率出降
//            return getProbability(detailDto, userInfoDto);
//        }
//        // 直接出降
//        return getDirect(detailDto, userInfoDto);
//    }
//    
//    private static ActivityCommonUserResultDto getProbability(ActivityCommonDetailDto detailDto, ActivityCommonUserInfoDto userInfoDto) {
//        return null;
//    }
//    
//    private static ActivityCommonUserResultDto buildBase(ActivityCommonDetailDto detailDto, ActivityCommonUserInfoDto userInfoDto) throws BizException {
//        ActivityCommonUserResultDto resultDto = new ActivityCommonUserResultDto();
//        resultDto.setCanTake(true);
//        // 回填 用户校验
//        // 回填 活动是否限制中奖次数，若限制的话回填剩余次数
//        fillActivityLimitNum(resultDto, detailDto, userInfoDto);
//        // 回填 黑名单
//        // 回填 白名单
//        return null;
//    }
//    
//    private static void fillUserVerify(ActivityCommonUserResultDto resultDto, ActivityCommonDetailDto detailDto, ActivityCommonUserInfoDto userInfoDto) {
//        
//    }
//    
//    private static boolean probabilityActivitySurplusNum(ActivityCommonDetailDto detailDto, ActivityCommonUserInfoDto userInfoDto) throws BizException {
//        // 活动中奖次数限制，剩余次数
//        long activityLimitNum = getActivityLimitSurplusNum(detailDto, userInfoDto);
//        // 白名单剩余次数
//        // 助力次数
//        return false;
//    }
//    
//    private static long getWhiteLimitSurplusNum(ActivityCommonDetailDto detailDto, ActivityCommonUserInfoDto userInfoDto) throws BizException {
//        ActivityCommonWhiteConfDto whiteDto = detailDto.getWhiteConf();
//        if (whiteDto == null) {
//            throwBiz(ActivityCommonErrorCodeEnum.AC000009);
//        }
//        if (!BooleanEnum.TRUE.getCode().equals(whiteDto.getEnable())) {
//            return -1;
//        }
//        return 0L;
//    }
//    
//    private static void fillActivityLimitNum(ActivityCommonUserResultDto resultDto, ActivityCommonDetailDto detailDto, ActivityCommonUserInfoDto userInfoDto) throws BizException {
//        if (!resultDto.isCanTake()) {
//            // 已经不可领取，不再计算活动剩余领取次数
//            return;
//        }
//        ActivityCommonTakeLimitConfDto takeNumLimit = detailDto.getActivityTakeNumLimit();
//        if (takeNumLimit == null) {
//            throwBiz(ActivityCommonErrorCodeEnum.AC000009);
//        }
//        if (!BooleanEnum.TRUE.getCode().equals(takeNumLimit.getEnable())) {
//            resultDto.setTakeNumLimit(BooleanEnum.FALSE.getCode());
//            return;
//        }
//        long surplusNum = getSurplusNum(takeNumLimit.getDetailList(), userInfoDto.getReceiveRecordList());
//        if (surplusNum < 1) {
//            resultDto.setCanTake(false);
//            resultDto.setCanNotTakeCode(ActivityCommonErrorCodeEnum.AC000014.name());
//        }
//        if (resultDto.getSurplusNum() == null) {
//            resultDto.setSurplusNum(surplusNum);
//            return;
//        }
//        resultDto.setSurplusNum(Math.min(surplusNum, resultDto.getSurplusNum()));
//    }
//    
//    private static long getActivityLimitSurplusNum(ActivityCommonDetailDto detailDto, ActivityCommonUserInfoDto userInfoDto) throws BizException {
//        ActivityCommonTakeLimitConfDto takeNumLimit = detailDto.getActivityTakeNumLimit();
//        if (takeNumLimit == null) {
//            throwBiz(ActivityCommonErrorCodeEnum.AC000009);
//        }
//        if (!BooleanEnum.TRUE.getCode().equals(takeNumLimit.getEnable())) {
//            return -1;
//        }
//        return getSurplusNum(takeNumLimit.getDetailList(), userInfoDto.getReceiveRecordList());
//    }
//    
//    private static long getSurplusNum(List<ActivityCommonTakeLimitConfDetailDto> detailList, List<ActivityPrizeReceiveRecordDto> receiveRecordList) throws BizException {
//        long minSurplusNum = Long.MAX_VALUE;
//        Date now = new Date();
//        for (ActivityCommonTakeLimitConfDetailDto detail : detailList) {
//            long surplusNum = getSurplusNum(detail, receiveRecordList, now);
//            if (surplusNum < minSurplusNum) {
//                minSurplusNum = surplusNum;
//            }
//        }
//        return minSurplusNum;
//    }
//
//    private static long getSurplusNum(ActivityCommonTakeLimitConfDetailDto detail, List<ActivityPrizeReceiveRecordDto> receiveRecordList, Date now) throws BizException {
//        ActivityPeriodicUnitEnum unitEnum = ActivityPeriodicUnitEnum.getByCode(detail.getPeriodicUnit());
//        if (unitEnum == null) {
//            throwBiz(ActivityCommonErrorCodeEnum.AC000011);
//        }
//        Pair<Date, Date> date = unitEnum.getDate(now, detail.getAbsoluteStartTime(), detail.getAbsoluteEndTime());
//        if (date == null) {
//            throwBiz(ActivityCommonErrorCodeEnum.AC000011);
//        }
//        long count = receiveRecordList.stream().filter(recordDto -> {
//            if (date.getLeft() != null && recordDto.getGmtCreate().getTime() < date.getLeft().getTime()) {
//                return false;
//            }
//            return date.getRight() == null || recordDto.getGmtCreate().getTime() < date.getRight().getTime();
//        }).count();
//        return detail.getTakeNum() - count;
//    }
//    
//    private static boolean activityCanTake() {
//        return false;
//    }
//    
//    private static ActivityCommonUserResultDto getDirect(ActivityCommonDetailDto detailDto, ActivityCommonUserInfoDto userInfoDto) {
//        return null;
//    }
//    
//    private static ActivityPrizeDrawTypeEnum getDrawType(ActivityCommonDetailDto detailDto) throws BizException {
//        Integer prizeDrawType = detailDto.getPrizeDrawType();
//        ActivityPrizeDrawTypeEnum drawTypeEnum = ActivityPrizeDrawTypeEnum.getByType(prizeDrawType);
//        if (drawTypeEnum == null) {
//            throwBiz(ActivityCommonErrorCodeEnum.AC000007);
//        }
//        return drawTypeEnum;
//    }
//    
    

}
